from PyQt5.QtWidgets import *
from PyQt5.QtCore import *
from PyQt5.QtGui import *

# Subclase QMainWindow
class VentanaPrincipal(QMainWindow):
    def __init__(self):
        super().__init__()
        self.setWindowTitle("Calculadora Chafa")
        contenedor = QWidget()
        lytPrincipal = QHBoxLayout()
        operandos = QFormLayout()
        operaciones = QVBoxLayout()
        
        self.op1 = QLineEdit()
        self.op2 = QLineEdit()
        self.op3 = QLineEdit()
        
        operandos.addRow("OP1", self.op1)
        operandos.addRow("OP2", self.op2)
        operandos.addRow("RES", self.op3)

        btnSuma = QPushButton("+")
        btnSuma.clicked.connect(self.clickSuma)
        
        btnResta = QPushButton("-")
#        btnResta.clicked.connect(self.clickResta)
        
        btnMulti = QPushButton("*")
#        btnMulti.clicked.connect(self.clickMulti)
        
        btnDiv = QPushButton("/")
#        btnDiv.clicked.connect(self.clickDiv)
        
        operaciones.addWidget(btnSuma)
        operaciones.addWidget(btnResta)
        operaciones.addWidget(btnMulti)
        operaciones.addWidget(btnDiv)
        
        lytPrincipal.addLayout(operandos)
        lytPrincipal.addLayout(operaciones)
        
        contenedor.setLayout(lytPrincipal)
        self.setCentralWidget(contenedor)

    def clickSuma(self):
        res = int(self.op1.text()) + int(self.op2.text())
        self.op3.setText(str(res))

app = QApplication([])
window = VentanaPrincipal()
window.show()

app.exec_()