﻿using System;
using System.Web;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Net;

namespace MemoQuitaMOPD
{
    public class MemoQuitaMOPD : IHttpModule
    {
        public void Init(HttpApplication context)
        {
            // Vamos a interferir justo después de pedir la autenticacion
            context.PostAuthenticateRequest += new EventHandler(context_PostAuthenticateRequest);
        }

        /// <summary>
        /// Esta se ejecuta justo despues de realizada la autenticacion. 
        /// Entonces ya sabemos quien es y podemos preguntar si esta autenticado.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e">Aqui viene la HttpApplication</param>
        void context_PostAuthenticateRequest(object sender, EventArgs e)
        {
            HttpApplication app = sender as HttpApplication;
            HttpContext context = app.Context;
            // Si no es anonimo, dejamos que SP trabaje normal
            if (context.User != null)
                if (context.User.Identity.IsAuthenticated)
                    return;
            // Es anonimo y ademas esta pidiendo la pagina download
            if (context.Request.RawUrl.ToString().IndexOf("download.aspx?SourceUrl") >= 0)
            {
                if (String.IsNullOrEmpty(context.Request.QueryString["SourceUrl"]) == false)
                {
                    WebClient client = new WebClient();
                    try
                    {
                        // Obtenemos la url
                        string url = context.Request.QueryString["SourceUrl"];
                        if (url.IndexOf("http://") < 0)
                            url = "http://" + context.Request.Url.Host + "/" + url;
                        // Obtenemos el nombre del archivo
                        string filename = Path.GetFileName(context.Request.QueryString["SourceUrl"]);
                        // SP reemplaza los espacios con guion bajo
                        filename = filename.Replace(' ', '_');
                        // Descargamos nuestro archivo en nuestro arreglo de bytes.
                        byte[] myDataBuffer = client.DownloadData(url);
                        context.Response.ClearHeaders();
                        context.Response.ClearContent();
                        // Nombre del archivo para que el usuario no vea download.aspx en el cuadro de descarga
                        context.Response.AddHeader("Content-Disposition", "attachment;filename=" + filename);
                        context.Response.ContentType = "application/octet-stream";
                        // Para mis amigos de otros idiomas:
                        // You only need to especify this line if your installation is in Spanish like mine
                        // This handles special chars like ñ, á, é, etc.
                        context.Response.HeaderEncoding = Encoding.GetEncoding("iso-8859-1");
                        // Mandamos OK al browser y servimos nuestro archivo
                        context.Response.StatusCode = 200;
                        context.Response.BinaryWrite(myDataBuffer);
                    }
                    catch
                    {
                        // Si hay algún error, mandamos un 404 NOT FOUND
                        context.Response.StatusCode = 404;
                    }
                    finally
                    {
                        client.Dispose();
                    }
                    context.Response.End();
                }
            }
        }

        /// <summary>
        /// Esta funcion es por si quieres imprimir mensajes en un archivo de texto para depurar la aplicacion.
        /// Por ejemplo si quieres ver que trae el URL: Log(context.Request.RawUrl.ToString(),app.Context);
        /// </summary>
        /// <param name="mensaje">Cadena a imprimir</param>
        /// <param name="context">El app.Context que viene en context_AuthenticateRequest</param>
        public void Log(string mensaje, HttpContext context)
        {
            StreamWriter LogFile = null;
            try
            {
                LogFile = new StreamWriter("c:\\Inetpub\\wwwroot\\log.txt", true);
                LogFile.WriteLine(System.DateTime.Now.ToString("dd/MM/yyyy hh:mm:ss tt") + " - " + mensaje);
                LogFile.Close();
                LogFile.Dispose();
            }
            catch
            {
                //No hace nada
            }
        }

        public void Dispose()
        {
        }
    }
}